<?php
include('header.php')
?>
		<!-- Breadcrumbs -->
        <div class="breadcrumbs overlay">
            <div class="container">
                <div class="bread-inner">
                    <div class="row">
                        <div class="col-12">
                            <h2><i class="fa fa-newspaper"></i> Blog Insights</h2>
                            <ul class="bread-list">
                                <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
                                <li><i class="icofont-simple-right"></i></li>
                                <li class="active"><i class="fa fa-book-open"></i> Blog Insights</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Breadcrumbs -->

		
		<!-- Single News -->
<section class="news-single section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 col-12">
                <div class="row">
                    <div class="col-12">
                        <div class="single-main">
                            <!-- News Head -->
                            <div class="news-head">
                                <img src="img/blog1.jpg" alt="Banking News">
                            </div>
                            <!-- News Title -->
                            <h1 class="news-title">
                                <a href="news-single.html">Financial Markets Embrace Digital Innovation</a>
                            </h1>
                            <!-- Meta -->
                            <div class="meta">
                                <div class="meta-left">
                                    <span class="author"><a href="#"><img src="img/author1.jpg" alt="Author">John Doe</a></span>
                                    <span class="date"><i class="fa fa-calendar"></i>May 02, 2025</span>
                                </div>
                                <div class="meta-right">
                                    <span class="comments"><a href="#"><i class="fa fa-comments"></i>12 Comments</a></span>
                                    <span class="views"><i class="fa fa-eye"></i>40K Views</span>
                                </div>
                            </div>
                            <!-- News Text -->
                            <div class="news-text">
                                <p>As banking institutions evolve, cutting-edge digital solutions redefine financial security and customer experience. From AI-driven fraud prevention to seamless online transactions, innovation continues to shape the future of finance.</p>
                                <p>Leading financial organizations prioritize transparency, security, and accessibility to build lasting relationships with clients worldwide.</p>

                                <div class="image-gallery">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-12">
                                            <div class="single-image">
                                                <img src="img/blog2.jpg" alt="Banking Trends">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6 col-12">
                                            <div class="single-image">
                                                <img src="img/blog3.jpg" alt="Financial Innovation">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <blockquote class="overlay">
                                    <p>“The future of banking isn’t just digital—it’s secure, intuitive, and customer-focused.”</p>                 
                                </blockquote>
                            </div>
                            
                            <div class="blog-bottom">
                                <!-- Social Share -->
                                <ul class="social-share">
                                    <li class="facebook"><a href="#"><i class="fa fa-facebook"></i><span>Facebook</span></a></li>
                                    <li class="twitter"><a href="#"><i class="fa fa-twitter"></i><span>Twitter</span></a></li>
                                    <li class="linkedin"><a href="#"><i class="fa fa-linkedin"></i><span>LinkedIn</span></a></li>
                                </ul>
                                <!-- Next Prev -->
                                <ul class="prev-next">
                                    <li class="prev"><a href="#"><i class="fa fa-angle-double-left"></i> Previous</a></li>
                                    <li class="next"><a href="#"><i class="fa fa-angle-double-right"></i> Next</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Blog Comments -->
                    <div class="col-12">
                        <div class="blog-comments">
                            <h2>Client Reviews</h2>
                            <div class="comments-body">
                                <!-- Single Comments -->
                                <div class="single-comments">
                                    <div class="main">
                                        <div class="head">
                                            <img src="img/author1.jpg" alt="Client"/>
                                        </div>
                                        <div class="body">
                                            <h4>Jane Smith</h4>
                                            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>May 02, 2025</span></div>
                                            <p>This banking platform delivers top-tier security with effortless transactions.</p>
                                            <a href="#"><i class="fa fa-reply"></i>Reply</a>
                                        </div>
                                    </div>
                                </div>      
								<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author2.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>Michael Johnson</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>May 01, 2025</span></div>
            <p>I've been using this banking service for years, and their seamless digital experience keeps improving. Highly recommend it!</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>

<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author3.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>Sophia Williams</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>April 28, 2025</span></div>
            <p>Fast, reliable, and secure—this platform makes managing finances easier than ever. Customer support is fantastic too!</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>

<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author4.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>David Brown</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>April 25, 2025</span></div>
            <p>The security features give me peace of mind, and the intuitive dashboard makes managing my accounts a breeze.</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>
<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author5.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>Emily Johnson</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>April 22, 2025</span></div>
            <p>Effortless banking with top-notch security! I love how seamless transactions are, and customer support is always responsive.</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>

<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author6.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>James Carter</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>April 18, 2025</span></div>
            <p>Security and convenience go hand in hand here. Managing accounts is easy, and the fraud protection tools give me confidence.</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>

<div class="single-comments">
    <div class="main">
        <div class="head">
            <img src="img/author7.jpg" alt="Client"/>
        </div>
        <div class="body">
            <h4>Olivia Martinez</h4>
            <div class="comment-meta"><span class="meta"><i class="fa fa-calendar"></i>April 15, 2025</span></div>
            <p>A truly reliable banking experience! The seamless mobile integration makes financial management effortless.</p>
            <a href="#"><i class="fa fa-reply"></i>Reply</a>
        </div>
    </div>
</div>


                            </div>
                        </div>
                    </div>

                    <!-- Comments Form -->
                    <div class="col-12">
                        <div class="comments-form">
                            <h2>Leave a Review</h2>
                            <form class="form" method="post" action="mail/mail.php">
                                <div class="row">
                                    <div class="col-lg-4 col-md-4 col-12">
                                        <div class="form-group">
                                            <i class="fa fa-user"></i>
                                            <input type="text" name="name" placeholder="Your Name" required="required">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-md-4 col-12">
                                        <div class="form-group">
                                            <i class="fa fa-envelope"></i>
                                            <input type="email" name="email" placeholder="Your Email" required="required">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group message">
                                            <i class="fa fa-pencil"></i>
                                            <textarea name="message" rows="7" placeholder="Share your experience"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <div class="form-group button"> 
                                            <button type="submit" class="btn primary"><i class="fa fa-send"></i>Submit Review</button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>  
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4 col-12">
                <div class="main-sidebar">
                    <!-- Search Widget -->
                    <div class="single-widget search">
                        <div class="form">
                            <input type="text" placeholder="Search Articles...">
                            <a class="button" href="#"><i class="fa fa-search"></i></a>
                        </div>
                    </div>

                    <!-- Blog Categories -->
                    <div class="single-widget category">
                        <h3 class="title">Financial Insights</h3>
                        <ul class="categor-list">
                            <li><a href="#">Investment Strategies</a></li>
                            <li><a href="#">Digital Banking</a></li>
                            <li><a href="#">Business Growth</a></li>
                        </ul>
                    </div>

                    <!-- Tags -->
                    <div class="single-widget side-tags">
                        <h3 class="title">Popular Tags</h3>
                        <ul class="tag">
                            <li><a href="#">banking</a></li>
                            <li><a href="#">finance</a></li>
                            <li><a href="#">investments</a></li>
                            <li><a href="#">security</a></li>
                            <li><a href="#">wealth</a></li>
                            <li><a href="#">markets</a></li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>

	<?php
include('footer.php')
?>